// Buffer.h: interface for the CBuffer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BUFFER_H__1C335BDF_C6C4_42E8_80A8_B820635076DC__INCLUDED_)
#define AFX_BUFFER_H__1C335BDF_C6C4_42E8_80A8_B820635076DC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//#musime pred nazev tridy uvest makro AFX_EXT_CLASS, ktere rika ze trida se da exportovat z knihovny
//muze byt definovano nasledovne
//
#ifndef BUFFER_API
	#define BUFFER_API __declspec(dllexport)
#endif

class BUFFER_API CBuffer  
{
private:
	char* mBuffer;  //ukazatel na buffer
	int mVelikost; //uchovava velikost bufferu
	BOOL mIsInit;   //uchovava zda uz byl volan konstruktor a jestli se povedlo inicializovat mBuffer
	int GetStrLen(char* lpStr); //funkce jen pro obejkt ktera bude vracet delku retezce na adrese lpStr
	int GetSpaceCount(BOOL iLeft); //vrati pocet mezer

public:
	//konstruktory
	CBuffer();
	CBuffer(int Size);
	CBuffer(int Size, char Znak);
	CBuffer(char* SBuffer);
	
	//kopirovaci konstruktor
	CBuffer(CBuffer& PuvBuffer);

	//destruktor
	virtual ~CBuffer();

	//metody
	void Format(const char* formatStr,...);
	void SetAt(char Znak); //nastavi vsechny znaky v retezci na znak Znak
	int WriteAt(int Pos, char Znak); //zapise Znak na pozici Pos v retezci
	char GetChar(int Pos); //vrati znak z pozice Pos
	void MakeUpper(); //prevede vsechny znaky na velke
	void MakeUpper(int Pos); //prevede znak na pozici Pos na velky
	void MakeLower(); //prevede vsechny znaky na male
	void MakeLower(int Pos); //prevede znak mna pozici Pos na maly
	void StandardOut(); //vypise buffer na standartni vystup
	char* Mid(int strPos, int nLength); //vrati ukazatel na urcitou cast retezce
	char* Left(int nLength); //vrati ukazatel na urcity pocet znaku z retezce z leve strany
	char* Right(int nLength); //vrati ukazatel na urcity pocet znaku z retezce z prave strany
	void Trim(); //vypreparuje zbytecne mezery zprava i zleva
	void TrimLeft(); //vypreparuje zbytecne mezery zleva
	void TrimRight(); //vypreparuje zbytecne mezery zprava
	BOOL Alloc(int nSize);	   //alokuje urcitou velikost pameti	
	void MakeEmpty();  //udela nulovy retezec, s delkou nula
	int FindFirst(char c); //najde pozici kde s epoprve vyskytuje zadany znak
	int FindLast(char c); //najde posledni pozici kde se vyskytuje dany znak
	//vlastnosti
	long GetLength();  //vrati delku retezce bez nuloveho znaku
	char* GetBuffer(); //vrati ukazatel na zacatek retezce
	BOOL IsEmpty();	   //rekne nam jestli retezec obsahuje nejake znaky
	WCHAR* GetUnicodeString();
	void SetLength(int NewLength) {mVelikost = NewLength;}

	//operatotry
	CBuffer& operator=(CBuffer& ZdrojBuf); //pretizeny operator =
	//objekt na prave starne bude reprezentovan promennou ZdrojBuf
	//obejkt na leve strane aktualni instanci obejktu CBuffer
	CBuffer& operator=(char* DestStr);
	CBuffer& operator+=(CBuffer& ZdrojBuf);
	CBuffer& operator+=(char* DestStr);
	CBuffer& operator+=(char nTmpChar);		//prida k retezci jeden znak
	operator const char*() {return mBuffer;};
	operator char*() {return mBuffer;};
	operator unsigned char*() {return (unsigned char*)mBuffer;};
};

#endif // !defined(AFX_BUFFER_H__1C335BDF_C6C4_42E8_80A8_B820635076DC__INCLUDED_)
